unit UStrumien;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, Grids, DBGrids, DB, DBClient;

Type

RecPojemnik = packed record
	nazwisko : String[25];
   imie     : String[15];
end;

MStrumien = class(TFileStream)
private
   bEndOfFile : Boolean;
   Rek        : RecPojemnik;

public
	procedure    Set_nazwisko(const Value : String);
	procedure    Set_imie(const Value : String);

   function     Get_nazwisko() : String;
   function     Get_imie() : String;
   function     Eof() : Boolean;

   procedure    Zapisz();
	procedure    Czytaj();

	constructor  Create(const AFileName: string; Mode: Word); overload;
   destructor   Destroy(); override;
end;

implementation
{------------------------------------------------------------------------------}
constructor MStrumien.Create(const AFileName: string; Mode: Word);
begin
	inherited Create(AFileName, Mode);

   Rek.nazwisko := '';
   Rek.imie     := '';

   bEndOfFile   := false;
end;

destructor MStrumien.Destroy();
begin
	inherited;
end;

function MStrumien.Get_imie() : String;
begin
	Result := Rek.imie;
end;

function MStrumien.Get_nazwisko() : String;
begin
	Result := Rek.nazwisko;
end;

procedure MStrumien.Set_imie(const Value : String);
begin
   Rek.imie := Value;
end;

procedure MStrumien.Set_nazwisko(const Value : String);
begin
   Rek.nazwisko := Value;
end;

procedure MStrumien.Zapisz();
begin
   Write(&Rek, sizeof(Rek));
end;

procedure MStrumien.Czytaj();
var
   bytes_read : Integer;

begin
   bytes_read := Read(&Rek, sizeof(Rek));

   if bytes_read <> sizeof(rek) then
	begin
      // ustawia dla Eof()
      bEndOfFile := true;
   end;
end;

function MStrumien.Eof() : Boolean;
begin
	Result := bEndOfFile;
end;

end.

